;/*************************************************
;Program			:4x3 Keypad
;Description		:scan 4x3 Keypad. MCU Port,PB3..PB0 are input(row) port 
;					:and PB6..PB4 are output(column) port.
;CPU Control		:ATmega163 
;File name			:key4x3.asm
;Assembler			:AVR Studio 4.05
; 
;**************************************************

.include "m163def.inc"

.org   	$000 
    		rjmp  reset			;Reset Handle

;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		counter3	= r18
.def		temp		= r19
.def		Column		= r20
.def		data		= r21
.def		temp1		= r22

;/***********************
; Define I/O Port,Pin
;/***********************
.equ		PORT_KBI	= PORTB
.equ		DDR_KBI		= DDRB
.equ		PIN_KBI		= PINB
.equ		Col			= 16			;frist column(0b00010000) 

;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	
main:		sbi	UCR,TXEN
			sbi	UCR,RXEN
			ldi	temp,51				;baudrate = 9600
			out	UBRR,temp

Key4x3:		ldi	ZH,high(2*Key4x3TB)		
			ldi	ZL,low(2*Key4x3TB)
			rcall	Intro
wait_key:	rcall	scan_key		;scan keypad
			brts	dsp_key
			rjmp	wait_key

;/******************************************
; convert keypad code to ascii code
;/******************************************
dsp_key:	cpi	data,$0A			;if data < 10 jump to dsp_key2 label
			brlo	dsp_key1		
			subi	data,-$37		;data = data+$37
			rcall	TX_Byte
			ldi	data,' '
			rcall	TX_Byte
			rcall	delay200ms
			rjmp	wait_key
dsp_key1:	subi	data,-$30		;data = data+$30
			rcall	TX_Byte
			ldi	data,' '
			rcall	TX_Byte
			rcall	delay200ms
			rjmp	wait_key

;/************
; scan key 
;/************
scan_key:	clr	counter3			;clear Column Counter
			ser	column
			out	DDR_KBI,column
			cbr	column,Col
scan_key1:	out	PORT_KBI,column		;set PORTB as output
			rcall	read_pin		;read data
			andi	temp,0x0F
			cpi	temp,0x0F
			brne	press
			sec						;set carry flag
			rol	column				;rotate left column register with carry 
			inc	counter3
			cpi	counter3,3
			breq	scan_key
			rjmp	scan_key1	

;/******************************************
; if key pressed, delay30ms check it again.  
;*******************************************
press:		rcall	delay30ms		;Debounce key
			out	PORT_KBI,column		;check status of key again
			rcall	read_pin
			andi	temp,0x0F
			cpi	temp,0x0F
			breq	scan_key		 
			ldi	data,0xFF
			ldi	ZH,high(KEY_TAB*2)
			ldi	ZL,low(KEY_TAB*2)
			andi	column,0xF0
			or	column,temp
key_code:	inc	data
			lpm
			mov	temp,r0
			set
			cp	temp,column
			breq	end_scan
			adiw	ZL,1
			cpi	data,11
			brne	key_code
			clt
end_scan:	ret

;/**************************
; Read data from PORT B
;/**************************
read_pin:	clr	temp1
			out	DDR_KBI,temp1		;clear PORTB as input
			in	temp,PIN_KBI		;read pin
			ser	temp1
			out	DDR_KBI,temp1
			ret

;/*************
; Send text
;/*************
Intro:		lpm
			tst	r0
			breq	end_sub
TX232:		sbis	USR,UDRE
			rjmp	TX232
			out	UDR,r0
			adiw	ZL,1
			rcall	delay1ms
			rjmp	Intro
end_sub:	ret		

;/******************
; Send a byte
;/******************

TX_Byte:	sbis	USR,UDRE
			rjmp	TX_Byte
			out	UDR,data
			ret
;/*****************
; Get a byte
;/*****************
RX_Byte:	sbis	USR,RXC
			rjmp	RX_Byte
			in	data,UDR
			ret
;/*****************
; delay time
;/*****************
delay1ms:	push	counter1
			push	counter2
			ldi	counter1,8
delay1ms_1: ldi    	counter2,250
delay1ms_2: nop
			dec    	counter2
            brne   	delay1ms_2
            dec    	counter1
            brne   	delay1ms_1
            pop	counter2
			pop	counter1
			ret          

delay10ms:	push	counter1
			push	counter2
			ldi    	counter1,80
delay10ms_1:   	
			ldi    	counter2,250
delay10ms_2:   	
			nop
			dec    	counter2
            brne   	delay10ms_2
            dec    	counter1
            brne   	delay10ms_1
            pop	counter2
			pop	counter1
			ret          

delay30ms:	ldi    	counter1,240
delay30ms_1:   	
			ldi    	counter2,250
delay30ms_2:   	
			nop
			dec    	counter2
            brne   	delay30ms_2
            dec    	counter1
            brne   	delay30ms_1
			ret          

delay200ms:	push	counter3
			ldi	counter3,200
delay200ms_1:	
			rcall	delay1ms
			dec	counter3
			brne	delay200ms_1
			pop	counter3
			ret

;/******************
; code segment
;/******************
KEY_TAB: 	.db	0xD7,0xEE,0xDE,0xBE		;0 1 2 3
			.db	0xED,0xDD,0xBD,0xEB		;4 5 6 7
			.db	0xDB,0xBB,0xE7,0xB7		;8 9 A B

Key4x3TB:	.db	0x0a,0x0d,"Test a 4x3 metrix Keyboard",0x0a,0x0d,"Please press any key. "
			.db	0x0a,0x0d,"You pressed :",0
           	 